//
//  ICommSide.h
//  iPassthru
//
//  Created by Sergey Pjatkin on 7/16/13.
//  Copyright (c) 2013 Ingenico. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <ExternalAccessory/ExternalAccessory.h>

#define STX 0x02
#define ETX 0x03
#define FS  0x1C
#define GS  0x1D
#define ACK 0x06
#define NAK 0x15

/*********************************** Protocol ***********************************/

@protocol IStreamManagerNotify <NSObject>
-(void) Connected:(NSString*)withDevice;
-(void) DataReceived;
-(void) Disconnected;
-(void) InputStreamClosed;
-(void) ErrorOccurred:(NSError*)error;
@end

/*********************************** iOSStream ***********************************/

@interface iOSStream : NSObject  <NSStreamDelegate>
{
@protected
    id<IStreamManagerNotify> m_delegate;

    NSMutableData * m_writeData;
    NSMutableData * m_readData;
    
    NSOutputStream* m_outputStream;
    NSInputStream * m_inputStream;
    
    NSString* m_remoteDeviceName;
}
-(BOOL) isDeviceConnected;
-(BOOL) isSessionConnected;
-(void) setRemoteDeviceName:(NSString*) deviceName;
-(NSString*) getRemoteDeviceName;
-(NSUInteger)readBytesAvailable;
-(NSData*) readData:(NSUInteger)bytesToRead;
-(void) writeData:(NSData *)data;
-(BOOL) Connect;
-(void) Disconnect;
-(void) Close;
@end

/*********************************** iOSAccessory ***********************************/

@interface iOSAccessory : iOSStream <EAAccessoryDelegate>
{
@private
    EAAccessory*    m_accessory;
    EASession*      m_session;
    NSString*       m_protocolString;
    
    BOOL            m_needToReconnect;
    BOOL            m_accessory_connected;
    BOOL            m_session_connected;
}
-(id) initWithDelegate:(id<IStreamManagerNotify> ) delegate;
-(BOOL) isDeviceConnected;
-(BOOL) isSessionConnected;
-(BOOL) Connect;
-(void) Disconnect;

-(NSData*) buildPacketWithData:(NSString*) data;
-(void) cancelCmdProcess;
-(void) sendCmd:(NSData*) data withTimeout:(int) timeout completionHandler:(void (^)(NSData* response,NSError* err)) completionHandler;

@end

