//
//  iPDCManager.h
//  iPDCLib
//
//  Created by jije jijesoft on 2017/12/25.
//  Copyright © 2017年 jijesoft. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "IStream.h"

@protocol IPDCManagerNotify <NSObject>
-(void) HttpsDataReceived:(NSData*)data;
-(void) HttpsErrorOccurred:(NSError*)error;
-(void) ICMErrorOccurred:(NSError*)error;
@end

@interface iPDCManager : NSObject<IStreamManagerNotify>
{
@private
    id<IPDCManagerNotify> m_delegate;
}
-(id) initWithDelegate:(id<IPDCManagerNotify>)delegate;
-(void) postTransactionToUrl:(NSString*) url request:(NSString*) request withTimeout:(int) timeout;
-(void) enableRushMode:(NSString*)url checkIntval:(int) interval  failedCnt:(int) count;
-(void) disableRushMode;
//-(void) processTransactionInRushMode:(NSString*) request;
@end
